/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.core;

import be.dnsbelgium.core.ByteUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CIDR {
    private final byte[] address;
    private final int size;
    private final byte[] mask;

    public CIDR(byte[] address, int size) {
        if (size < 1 || size > address.length * 8) {
            throw new IllegalArgumentException();
        }
        byte[] mask = ByteUtils.getMask(size, address.length * 8);
        byte[] maskedAddress = ByteUtils.and(address, mask);
        if (!ByteUtils.isSame(address, maskedAddress)) {
            throw new IllegalArgumentException("Invalid address");
        }
        this.address = (byte[])address.clone();
        this.size = size;
        this.mask = mask;
    }

    public byte[] getAddress() {
        return (byte[])this.address.clone();
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getMask() {
        return (byte[])this.mask.clone();
    }

    public boolean contains(InetAddress inet) {
        byte[] inetaddr = inet.getAddress();
        if (inetaddr.length != this.address.length) {
            throw new IllegalArgumentException("argument is other type of inet address");
        }
        byte[] result = ByteUtils.and(inetaddr, this.mask);
        return ByteUtils.isSame(this.address, result);
    }

    public static CIDR of(String cidr) {
        String[] parts = cidr.split("\\/");
        if (parts.length == 1) {
            try {
                InetAddress address = InetAddress.getByName(parts[1]);
                return new CIDR(address.getAddress(), address.getAddress().length);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid format");
        }
        try {
            InetAddress address = InetAddress.getByName(parts[0]);
            return new CIDR(address.getAddress(), Integer.parseInt(parts[1]));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

