/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.client;

import be.dnsbelgium.rdap.client.Utils;
import be.dnsbelgium.rdap.jackson.CustomObjectMapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDAPClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDAPClient.class);
    private final HttpClient httpClient;
    private final HttpHost host;
    private final String path;
    private final ObjectMapper mapper;

    public static KeyStore getKeyStoreFromFile(File file, String password) throws KeyStoreException {
        return RDAPClient.getKeyStoreFromFile(file, KeyStore.getDefaultType(), password);
    }

    public static KeyStore getKeyStoreFromFile(File file, String type, String password) throws KeyStoreException {
        KeyStore result = KeyStore.getInstance(type);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            result.load(fis, password.toCharArray());
        }
        catch (IOException e) {
            LOGGER.error("Could not load keystore file", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new KeyStoreException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Could not close keystore file", (Throwable)e);
                }
            }
        }
        return result;
    }

    public static KeyStore getPKCS12KeyStoreFromFile(File file, String password) throws KeyStoreException {
        return RDAPClient.getKeyStoreFromFile(file, "PKCS12", password);
    }

    public RDAPClient(HttpClient httpClient, String baseUrl) throws URISyntaxException {
        this.httpClient = httpClient;
        URI uri = new URI(baseUrl);
        this.path = uri.getPath().startsWith("/") ? uri.getPath() : "/" + uri.getPath();
        this.host = Utils.httpHost(baseUrl);
        this.mapper = new CustomObjectMapper();
    }

    public JsonNode getDomainAsJson(String domainName) throws RDAPClientException {
        return this.query("domain", domainName);
    }

    public JsonNode getEntityAsJson(String entityId) throws RDAPClientException {
        return this.query("entity", entityId);
    }

    public JsonNode getAutNum(String autnum) throws RDAPClientException {
        return this.query("autnum", autnum);
    }

    public JsonNode getIp(String ip) throws RDAPClientException {
        return this.query("ip", ip);
    }

    public JsonNode getNameserver(String nameserver) throws RDAPClientException {
        return this.query("nameserver", nameserver);
    }

    private JsonNode query(String subpath, String query) throws RDAPClientException {
        HttpGet method = null;
        try {
            method = new HttpGet(String.format("%s/%s/%s", this.path, subpath, URLEncoder.encode(query, "UTF-8")));
            HttpResponse response = this.httpClient.execute(this.host, (HttpRequest)method);
            HttpEntity entity = response.getEntity();
            return this.mapper.readTree(entity.getContent());
        }
        catch (UnsupportedEncodingException e) {
            throw new RDAPClientException("UTF-8 is an unsupported encoding", e);
        }
        catch (IOException e) {
            throw new RDAPClientException(String.format("Could not get %s information for %s", subpath, query), e);
        }
    }

    public static class RDAPClientException
    extends Exception
    implements Serializable {
        private static final long serialVersionUID = -7254946457661245754L;

        public RDAPClientException() {
        }

        public RDAPClientException(String message) {
            super(message);
        }

        public RDAPClientException(String message, Throwable cause) {
            super(message, cause);
        }

        public RDAPClientException(Throwable cause) {
            super(cause);
        }
    }
}

