/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.client;

import be.dnsbelgium.core.DomainName;
import be.dnsbelgium.rdap.client.RDAPClient;
import be.dnsbelgium.rdap.client.RDAPOptions;
import be.dnsbelgium.rdap.client.Utils;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class RDAPCLI {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDAPCLI.class);

    private RDAPCLI() {
    }

    public static void main(String[] args) {
        LOGGER.debug("Create the command line parser");
        GnuParser parser = new GnuParser();
        LOGGER.debug("Create the options");
        RDAPOptions options = new RDAPOptions(Locale.ENGLISH);
        try {
            LOGGER.debug("Parse the command line arguments");
            CommandLine line = parser.parse((Options)options, args);
            if (line.hasOption("help")) {
                RDAPCLI.printHelp(options);
                return;
            }
            if (line.getArgs().length == 0) {
                throw new IllegalArgumentException("You must provide a query");
            }
            String query = line.getArgs()[0];
            Type type = line.getArgs().length == 2 ? Type.valueOf(line.getArgs()[1].toUpperCase()) : RDAPCLI.guessQueryType(query);
            LOGGER.debug("Query: {}, Type: {}", (Object)query, (Object)type);
            try {
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (line.hasOption("truststore")) {
                    sslContextBuilder.loadTrustMaterial(RDAPClient.getKeyStoreFromFile(new File(line.getOptionValue("truststore")), line.getOptionValue("truststoretype", "JKS"), line.getOptionValue("truststorepass", "changeit")));
                }
                if (line.hasOption("keystore")) {
                    sslContextBuilder.loadKeyMaterial(RDAPClient.getKeyStoreFromFile(new File(line.getOptionValue("keystore")), line.getOptionValue("keystoretype", "JKS"), line.getOptionValue("keystorepass", "changeit")), line.getOptionValue("keystorepass", "changeit").toCharArray());
                }
                SSLContext sslContext = sslContextBuilder.build();
                String url = line.getOptionValue("url");
                HttpHost host = Utils.httpHost(url);
                HashSet<BasicHeader> headers = new HashSet<BasicHeader>();
                headers.add(new BasicHeader("Accept-Language", line.getOptionValue("lang", Locale.getDefault().toString())));
                HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultHeaders(headers).setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)(line.hasOption("insecure") ? new AllowAllHostnameVerifier() : new BrowserCompatHostnameVerifier())));
                if (line.hasOption("username") && line.hasOption("password")) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(new AuthScope(host.getHostName(), host.getPort()), (Credentials)new UsernamePasswordCredentials(line.getOptionValue("username"), line.getOptionValue("password")));
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                RDAPClient rdapClient = new RDAPClient((HttpClient)httpClientBuilder.build(), url);
                ObjectMapper mapper = new ObjectMapper();
                JsonNode json = null;
                switch (type) {
                    case DOMAIN: {
                        json = rdapClient.getDomainAsJson(query);
                        break;
                    }
                    case ENTITY: {
                        json = rdapClient.getEntityAsJson(query);
                        break;
                    }
                    case AUTNUM: {
                        json = rdapClient.getAutNum(query);
                        break;
                    }
                    case IP: {
                        json = rdapClient.getIp(query);
                        break;
                    }
                    case NAMESERVER: {
                        json = rdapClient.getNameserver(query);
                    }
                }
                PrintWriter out = new PrintWriter(System.out, true);
                if (line.hasOption("raw")) {
                    mapper.writer().writeValue((Writer)out, (Object)json);
                } else if (line.hasOption("pretty")) {
                    mapper.writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValue((Writer)out, (Object)json);
                } else if (line.hasOption("yaml")) {
                    DumperOptions dumperOptions = new DumperOptions();
                    dumperOptions.setPrettyFlow(true);
                    dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                    dumperOptions.setSplitLines(true);
                    Yaml yaml = new Yaml(dumperOptions);
                    Map data = (Map)mapper.convertValue((Object)json, Map.class);
                    yaml.dump((Object)data, (Writer)out);
                } else {
                    mapper.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValue((Writer)out, (Object)json);
                }
                out.flush();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                System.exit(-1);
            }
        }
        catch (ParseException e) {
            RDAPCLI.printHelp(options);
            System.exit(-1);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("rdap [ OPTIONS ]... [ QUERY ] [ TYPE ]\n", null, options, "\n", true);
    }

    public static Type guessQueryType(String query) {
        try {
            if (query.matches("^\\d+$")) {
                return Type.AUTNUM;
            }
            if (query.matches("^[\\d\\.:/]+$")) {
                return Type.IP;
            }
            if (DomainName.of((String)query).getLevelSize() > 1) {
                return Type.DOMAIN;
            }
            return Type.ENTITY;
        }
        catch (IllegalArgumentException iae) {
            LOGGER.debug("Not a domain name, defaulting to entity", (Throwable)iae);
            return Type.ENTITY;
        }
    }

    public static enum Type {
        DOMAIN,
        ENTITY,
        NAMESERVER,
        AUTNUM,
        IP;

    }
}

