/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.client;

import java.util.Locale;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class RDAPOptions
extends Options {
    public static final String URL = "url";
    public static final String TRUSTSTORE_PASS = "truststorepass";
    public static final String DEFAULT_PASS = "changeit";
    public static final String DEFAULT_STORETYPE = "JKS";
    public static final String KEYSTORE_PASS = "keystorepass";
    public static final String KEYSTORE = "keystore";
    public static final String KEYPASS = "keypass";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String KEYSTORE_TYPE = "keystoretype";
    public static final String TRUSTSTORE_TYPE = "truststoretype";
    public static final String RAW = "raw";
    public static final String PRETTY = "pretty";
    public static final String LANG = "lang";
    public static final String TRUSTSTORE = "truststore";
    private static final long serialVersionUID = 3032718269550334306L;

    public RDAPOptions(Locale locale) {
        this.addOption(null, "version", false, "display version, authors and licensing information.");
        this.addOption(null, "help", false, "display a short help text.");
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"uses FILE as a configuration file instead of the default.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        this.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)URL);
        OptionBuilder.withDescription((String)"overrides any hosts in the configuration file and queries HOST directly.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"URL");
        this.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withLongOpt((String)USERNAME);
        OptionBuilder.withDescription((String)"Specify a username to be used with Basic Authentication.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"USERNAME");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)KEYSTORE);
        OptionBuilder.withDescription((String)"Tells rdap to use the specified keystore file when getting info with RDAP");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)KEYSTORE_TYPE);
        OptionBuilder.withDescription((String)String.format("Type of the keystore. Either JKS or PKCS12, default is %s", DEFAULT_STORETYPE));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"TYPE");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)KEYSTORE_PASS);
        OptionBuilder.withDescription((String)String.format("Tells rdap to use the specified keystore file when getting info with RDAP. Default value is changeit", DEFAULT_PASS));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PASSWORD");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)KEYPASS);
        OptionBuilder.withDescription((String)String.format("Tells rdap to use the specified key password when getting info with RDAP. Default value is %s", DEFAULT_PASS));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PASSWORD");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)TRUSTSTORE);
        OptionBuilder.withDescription((String)"Tells curl to use the specified certificate file to verify the peer. The file may contain multiple CA certificates. The certificate(s) must be\n in PEM format.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)TRUSTSTORE_TYPE);
        OptionBuilder.withDescription((String)"Type of the truststore. Either JKS or PKCS12");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"TYPE");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)TRUSTSTORE_PASS);
        OptionBuilder.withDescription((String)String.format("Tells rdap to use the specified keystore file when getting info with RDAP. Default value is %s", DEFAULT_PASS));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PASSWORD");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"insecure");
        OptionBuilder.withDescription((String)"This option explicitly allows RDAP to perform \"insecure\" SSL connections");
        this.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)RAW);
        OptionBuilder.withDescription((String)"Causes rdap to emit raw (not pretty-printed) JSON rather than text output.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)PRETTY);
        OptionBuilder.withDescription((String)"Causes rdap to emit pretty-printed JSON rather than text output.");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"location");
        OptionBuilder.withDescription((String)"If  the server reports that the requested page has moved to a different location (indicated with a Location: header and a 3XX response\n code), this option will make curl redo the request on the new place");
        this.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)PASSWORD);
        OptionBuilder.withDescription((String)"Specify a password to be used with Basic Authentication.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PASSWORD");
        this.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)LANG);
        OptionBuilder.withDescription((String)"Specify a language. This is sent to the server using the Accept-Language header. If unset, the language will be taken from your $LANG environment variable (or en if that is not defined).");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"LANG");
        this.addOption(OptionBuilder.create());
    }
}

