/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.client;

import be.dnsbelgium.rdap.core.Domain;
import be.dnsbelgium.rdap.jackson.CustomObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDAPClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDAPClient.class);
    private final HttpClient httpClient;
    private final ObjectMapper mapper;

    public static KeyStore getKeyStoreFromFile(File file, String password) throws KeyStoreException {
        return RDAPClient.getKeyStoreFromFile(file, KeyStore.getDefaultType(), password);
    }

    public static KeyStore getKeyStoreFromFile(File file, String type, String password) throws KeyStoreException {
        KeyStore result = KeyStore.getInstance(type);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            result.load(fis, password.toCharArray());
        }
        catch (IOException e) {
            LOGGER.error("Could not load keystore file", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new KeyStoreException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Could not close keystore file", (Throwable)e);
                }
            }
        }
        return result;
    }

    public static KeyStore getPKCS12KeyStoreFromFile(File file, String password) throws KeyStoreException {
        return RDAPClient.getKeyStoreFromFile(file, "PKCS12", password);
    }

    public RDAPClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.mapper = new CustomObjectMapper();
    }

    public Domain getDomain(String domainName) throws RDAPClientException {
        try {
            HttpGet method = new HttpGet(String.format("/rdap/domain/%s", URLEncoder.encode(domainName, "UTF-8")));
            method.setHeader("Accept", "application/rdap+json");
            HttpResponse response = this.httpClient.execute((HttpUriRequest)method);
            HttpEntity entity = response.getEntity();
            return (Domain)this.mapper.readValue(entity.getContent(), Domain.class);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("UTF-8 is an unsupported encoding", (Throwable)e);
            throw new RDAPClientException("Error in getting domain", e);
        }
        catch (IOException e) {
            LOGGER.error("IO Exception", (Throwable)e);
            throw new RDAPClientException("Error in getting domain", e);
        }
    }

    public JsonNode getDomainAsJson(String domainName) throws RDAPClientException {
        HttpGet method = null;
        try {
            method = new HttpGet(String.format("/rdap/domain/%s", URLEncoder.encode(domainName, "UTF-8")));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)method);
            HttpEntity entity = response.getEntity();
            return this.mapper.readTree(entity.getContent());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("UTF-8 is an unsupported encoding", (Throwable)e);
            throw new RDAPClientException("Error in getting domain", e);
        }
        catch (IOException e) {
            LOGGER.error("IO Exception", (Throwable)e);
            throw new RDAPClientException("Error in getting domain", e);
        }
    }

    public static class Builder {
        public static final Logger LOGGER = LoggerFactory.getLogger(Builder.class);
        public static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
        public static final String HTTP = "http";
        public static final String HTTPS = "https";
        private String lang = null;
        private String username = null;
        private String password = null;
        private URL baseURL = null;

        public Builder setLanguage(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder setBaseURL(String url) {
            try {
                this.baseURL = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed URL", e);
            }
            return this;
        }

        public Builder setUsernamePassword(String username, String password) {
            if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)password)) {
                throw new IllegalArgumentException("username and password should both not be empty");
            }
            this.username = username;
            this.password = password;
            return this;
        }

        public RDAPClient build() {
            int port = this.baseURL.getPort();
            if (port == -1 && HTTP.equalsIgnoreCase(this.baseURL.getProtocol())) {
                port = 80;
            }
            if (port == -1 && HTTPS.equalsIgnoreCase(this.baseURL.getProtocol())) {
                port = 443;
            }
            LOGGER.debug("Initializing keystores");
            HttpClient httpClient = null;
            LOGGER.debug("Setting default headers");
            HashSet<BasicHeader> headers = new HashSet<BasicHeader>();
            if (!StringUtils.isEmpty((String)this.lang)) {
                LOGGER.debug("Adding language header: {}", (Object)this.lang);
                headers.add(new BasicHeader(ACCEPT_LANGUAGE_HEADER, this.lang));
            }
            LOGGER.debug("Setting username and password");
            if (StringUtils.isEmpty((String)this.username) || !StringUtils.isEmpty((String)this.password)) {
                // empty if block
            }
            httpClient.getParams().setParameter("http.default-headers", headers);
            return new RDAPClient(httpClient);
        }
    }

    public static class RDAPClientException
    extends Exception
    implements Serializable {
        private static final long serialVersionUID = -7254946457661245754L;

        public RDAPClientException() {
        }

        public RDAPClientException(String message) {
            super(message);
        }

        public RDAPClientException(String message, Throwable cause) {
            super(message, cause);
        }

        public RDAPClientException(Throwable cause) {
            super(cause);
        }
    }
}

