/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.client;

import be.dnsbelgium.core.DomainName;
import be.dnsbelgium.rdap.client.RDAPClient;
import be.dnsbelgium.rdap.client.RDAPOptions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.util.DefaultPrettyPrinter;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDAPCLI {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDAPCLI.class);
    public static final String HTTP = "http";
    public static final String HTTPS = "https";

    private RDAPCLI() {
    }

    public static void main(String[] args) {
        AnsiConsole.systemInstall();
        LOGGER.debug("Create the command line parser");
        GnuParser parser = new GnuParser();
        LOGGER.debug("Create the options");
        RDAPOptions options = new RDAPOptions(Locale.ENGLISH);
        try {
            LOGGER.debug("Parse the command line arguments");
            CommandLine line = parser.parse((Options)options, args);
            if (line.hasOption("help")) {
                HelpFormatter hf = new HelpFormatter();
                hf.printHelp("rdap [ OPTIONS ]... [ QUERY ] [ TYPE ]\n", null, (Options)options, null, true);
                System.out.println();
                return;
            }
            if (line.getArgs().length == 0) {
                throw new IllegalArgumentException("You must provide a query");
            }
            String query = line.getArgs()[0];
            Type type = line.getArgs().length == 2 ? Type.valueOf(line.getArgs()[1].toUpperCase()) : RDAPCLI.guess(query);
            LOGGER.debug("Query: {}, Type: {}", (Object)query, (Object)type);
            try {
                URL url = new URL(line.getOptionValue("url"));
                int port = url.getPort();
                if (port == -1 && HTTP.equalsIgnoreCase(url.getProtocol())) {
                    port = 80;
                }
                if (port == -1 && HTTPS.equalsIgnoreCase(url.getProtocol())) {
                    port = 443;
                }
                KeyStore trustStore = line.hasOption("truststore") ? RDAPClient.getKeyStoreFromFile(new File(line.getOptionValue("truststore")), line.getOptionValue("truststoretype", "JKS"), line.getOptionValue("truststorepass", "changeit")) : null;
                KeyStore keyStore = line.hasOption("keystore") ? RDAPClient.getKeyStoreFromFile(new File(line.getOptionValue("keystore")), line.getOptionValue("keystoretype", "JKS"), line.getOptionValue("keystorepass", "changeit")) : null;
                SSLSocketFactory socketFactory = new SSLSocketFactory(keyStore, line.getOptionValue("keypass", "changeit"), trustStore);
                Scheme scheme = new Scheme(HTTPS, port, (SchemeSocketFactory)socketFactory);
                SchemeRegistry registry = new SchemeRegistry();
                registry.register(scheme);
                HttpClientBuilder builder = HttpClientBuilder.create();
                DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)new BasicClientConnectionManager(registry));
                httpClient.getParams().setParameter("http.default-host", (Object)new HttpHost(url.getHost(), url.getPort(), url.getProtocol()));
                if (line.hasOption("username") && line.hasOption("password")) {
                    httpClient.getCredentialsProvider().setCredentials(new AuthScope(url.getHost(), port), (Credentials)new UsernamePasswordCredentials(line.getOptionValue("username"), line.getOptionValue("password")));
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(new AuthScope(url.getHost(), port), (Credentials)new UsernamePasswordCredentials(line.getOptionValue("username"), line.getOptionValue("password")));
                    builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                HashSet<BasicHeader> headers = new HashSet<BasicHeader>();
                headers.add(new BasicHeader("Accept-Language", line.getOptionValue("lang", Locale.getDefault().toString())));
                httpClient.getParams().setParameter("http.default-headers", headers);
                builder.setDefaultHeaders(Collections.singleton(new BasicHeader("Accept-Language", line.getOptionValue("lang", Locale.getDefault().toString()))));
                RDAPClient rdapClient = new RDAPClient((HttpClient)httpClient);
                if (line.hasOption("raw")) {
                    ObjectMapper mapper = new ObjectMapper();
                    System.out.println(mapper.writer().writeValueAsString((Object)rdapClient.getDomainAsJson(query)));
                } else if (line.hasOption("pretty")) {
                    ObjectMapper mapper = new ObjectMapper();
                    System.out.println(mapper.writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)rdapClient.getDomainAsJson(query)));
                }
            }
            catch (UnrecoverableKeyException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (KeyStoreException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (KeyManagementException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (RDAPClient.RDAPClientException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Type guess(String query) {
        try {
            if (query.matches("^\\d+$")) {
                return Type.AUTNUM;
            }
            if (query.matches("^[\\d\\.:/]+$")) {
                return Type.IP;
            }
            if (DomainName.of((String)query).getLevelSize() > 1) {
                return Type.DOMAIN;
            }
            return Type.ENTITY;
        }
        catch (IllegalArgumentException iae) {
            LOGGER.debug("Not a domain name, defaulting to entity", (Throwable)iae);
            return Type.ENTITY;
        }
    }

    public static enum Type {
        DOMAIN,
        ENTITY,
        NAMESERVER,
        AUTNUM,
        IP;

    }
}

