/*
 * Decompiled with CFR 0.152.
 */
package be.dem.container;

import be.dem.container.ContainerException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Map<Class, Object> mapping = new HashMap<Class, Object>();
    private final Map<Class, Object> mappingSingleton = new HashMap<Class, Object>();
    private static Container instance;

    private Container() {
    }

    private static Container getInstance() {
        if (instance == null) {
            instance = new Container();
        }
        return instance;
    }

    public static <T> void bind(Class from, T to) {
        if (to instanceof Class) {
            to = Container.resolve((Class)to, new Object[0]);
        }
        if (!from.isInterface()) {
            throw new ContainerException(String.format("%s is not an interface.", from.getName()));
        }
        if (!from.isAssignableFrom(to.getClass())) {
            throw new ContainerException(String.format("The concrete class %s must implement the interface %s.", to.getClass().getName(), from.getName()));
        }
        Container.getInstance().mapping.put(from, to);
    }

    public static <T> void bindSingleton(Class from) {
        Container.getInstance().mappingSingleton.put(from, null);
    }

    private static <T> T resolveInterface(Class<T> toBeResolved) {
        if (toBeResolved.isInterface()) {
            Object result = Container.getInstance().mapping.get(toBeResolved);
            if (result != null) {
                return (T)result;
            }
            throw new ContainerException(String.format("There is no binding specified for the interface %s", toBeResolved.getName()));
        }
        return null;
    }

    private static <T> T resolveSingleton(Class<T> toBeResolved, Object[] params) {
        boolean isSingleton = Container.getInstance().mappingSingleton.containsKey(toBeResolved);
        if (isSingleton) {
            Object result = Container.getInstance().mappingSingleton.get(toBeResolved);
            if (result == null) {
                result = Container.createClass(toBeResolved, params);
                Container.getInstance().mappingSingleton.replace(toBeResolved, result);
            }
            return (T)result;
        }
        return null;
    }

    public static <T> T resolve(Class<T> toBeResolved, Object ... params) {
        T result = Container.resolveInterface(toBeResolved);
        if (result != null) {
            return result;
        }
        result = Container.resolveSingleton(toBeResolved, params);
        if (result != null) {
            return result;
        }
        return Container.createClass(toBeResolved, params);
    }

    private static <T> T createClass(Class<T> toBeResolved, Object[] params) {
        try {
            Constructor constructor = Container.getInstance().getConstructor(toBeResolved);
            ArrayList<Object> parameters = new ArrayList<Object>();
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            for (Object param : params) {
                parameters.add(param);
            }
            for (int i = parameters.size(); i < parameterTypes.length; ++i) {
                parameters.add(Container.resolve(parameterTypes[i], new Object[0]));
            }
            return constructor.newInstance(parameters.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new ContainerException("An Exception has been thrown when making a Class", ex);
        }
    }

    public static void clear() {
        Container.getInstance().mapping.clear();
    }

    private <T> Constructor getConstructor(Class<T> toBeResolved) {
        Constructor<?>[] constructors = toBeResolved.getConstructors();
        if (constructors.length > 1) {
            throw new ContainerException(String.format("The %s class should only have one constructor: ", toBeResolved.getName()));
        }
        return constructors[0];
    }
}

