/*
 * Decompiled with CFR 0.152.
 */
package be.davidopdebeeck.document.randomizer.xml;

import be.davidopdebeeck.document.randomizer.document.DocumentFactory;
import be.davidopdebeeck.document.randomizer.input.Input;
import be.davidopdebeeck.document.randomizer.input.InputSource;
import be.davidopdebeeck.document.randomizer.xml.XmlDocument;
import io.reactivex.Flowable;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.io.SAXReader;

public class XmlDocumentFactory
implements DocumentFactory<XmlDocument> {
    private final SAXReader saxReader = new SAXReader();

    @Override
    public Flowable<XmlDocument> createDocument(InputSource<?> source) {
        return source.getSource().map(this::mapToXmlDocument);
    }

    private XmlDocument mapToXmlDocument(Input input) {
        try {
            return new XmlDocument(this.saxReader.read((Reader)new StringReader(input.getContent())));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to extract document from %s", input.getContent()));
        }
    }
}

