/*
 * Decompiled with CFR 0.152.
 */
package be.davidopdebeeck.document.randomizer.xml;

import be.davidopdebeeck.document.randomizer.element.Element;
import be.davidopdebeeck.document.randomizer.xml.XmlElement;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlDocument
implements be.davidopdebeeck.document.randomizer.document.Document {
    private static final OutputFormat outputFormat = OutputFormat.createPrettyPrint();
    private final Document document;

    XmlDocument(Document document) {
        this.document = document;
    }

    @Override
    public List<Element> findElementsBy(String xpath) {
        return this.findNodes(xpath).stream().map(XmlElement::new).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLWriter writer = new XMLWriter((OutputStream)outputStream, outputFormat);
            writer.write(this.document);
            writer.flush();
            writer.close();
            return new String(outputStream.toByteArray(), Charset.defaultCharset());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert xml file to string");
        }
    }

    private List<Node> findNodes(String xpath) {
        return this.document.selectNodes(xpath);
    }
}

