/*
 * Decompiled with CFR 0.152.
 */
package be.davidopdebeeck.document.randomizer.json;

import be.davidopdebeeck.document.randomizer.document.DocumentFactory;
import be.davidopdebeeck.document.randomizer.input.Input;
import be.davidopdebeeck.document.randomizer.input.InputSource;
import be.davidopdebeeck.document.randomizer.json.JsonDocument;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import io.reactivex.Flowable;

public class JsonDocumentFactory
implements DocumentFactory<JsonDocument> {
    @Override
    public Flowable<JsonDocument> createDocument(InputSource<?> source) {
        return source.getSource().map(this::mapToJsonDocument);
    }

    private JsonDocument mapToJsonDocument(Input input) {
        return new JsonDocument(this.pathContext(input), this.mutableContext(input));
    }

    private DocumentContext pathContext(Input input) {
        return JsonPath.parse((String)input.getContent(), (Configuration)Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build());
    }

    private DocumentContext mutableContext(Input input) {
        return JsonPath.parse((String)input.getContent(), (Configuration)Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
    }
}

