/*
 * Decompiled with CFR 0.152.
 */
package be.davidopdebeeck.document.randomizer.input.file;

import be.davidopdebeeck.document.randomizer.input.Input;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileInput
implements Input {
    private static final String EMPTY = "";
    private final File file;

    public FileInput(File file) {
        this.file = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getContent() {
        try (Stream<String> lines = Files.lines(this.file.toPath(), Charset.defaultCharset());){
            String string = lines.collect(Collectors.joining(EMPTY));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to read file %s", this.file.getAbsolutePath()));
        }
    }
}

