/*
 * Decompiled with CFR 0.152.
 */
package be.davidopdebeeck.document.randomizer.input.file;

import be.davidopdebeeck.document.randomizer.input.InputSource;
import be.davidopdebeeck.document.randomizer.input.file.FileInput;
import io.reactivex.Flowable;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DirectoryInputSource
implements InputSource<FileInput> {
    private final File directory;
    private final String fileExtension;

    public DirectoryInputSource(String path) {
        this.directory = new File(path);
        this.fileExtension = null;
    }

    public DirectoryInputSource(String path, String fileExtension) {
        this.directory = new File(path);
        this.fileExtension = fileExtension;
    }

    @Override
    public Flowable<FileInput> getSource() {
        return Flowable.fromIterable(this.findAllFilesWithExtension()).map(FileInput::new);
    }

    private List<File> findAllFilesWithExtension() {
        File[] filesWithExtension = this.directory.listFiles(this::hasExtension);
        return filesWithExtension == null ? Collections.emptyList() : Arrays.asList(filesWithExtension);
    }

    private boolean hasExtension(File file) {
        return this.fileExtension == null || file.getName().endsWith(this.fileExtension);
    }
}

