/*
 * Decompiled with CFR 0.152.
 */
package be.davidopdebeeck.document.randomizer.input;

import be.davidopdebeeck.document.randomizer.input.Input;
import be.davidopdebeeck.document.randomizer.input.InputSource;
import io.reactivex.Flowable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CompositeInputSource<I extends Input>
implements InputSource<I> {
    private final List<InputSource<I>> inputSources;

    @SafeVarargs
    public CompositeInputSource(InputSource<I> ... inputSources) {
        this(Arrays.asList(inputSources));
    }

    public CompositeInputSource(List<InputSource<I>> inputSources) {
        Objects.requireNonNull(inputSources);
        this.inputSources = inputSources;
    }

    @Override
    public Flowable<I> getSource() {
        return Flowable.merge((Iterable)this.inputSources.stream().map(InputSource::getSource).collect(Collectors.toList()));
    }
}

