/*
 * Decompiled with CFR 0.152.
 */
package be.davidopdebeeck.document.randomizer.element.provider.file;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<String> readFileLines(File file) {
        try (Stream<String> lines = Files.lines(file.toPath(), Charset.defaultCharset());){
            List<String> list = lines.collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to read file: %s", file.getAbsolutePath()));
        }
    }
}

