/*
 * Decompiled with CFR 0.152.
 */
package be.davidopdebeeck.document.randomizer.element.provider.collection;

import be.davidopdebeeck.document.randomizer.element.provider.ElementValueProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class CollectionSequentialElementValueProvider<O>
implements ElementValueProvider {
    private final List<O> values;
    private final AtomicInteger currentCount;

    public static <O> ElementValueProvider sequentialValues(Collection<O> values) {
        return new CollectionSequentialElementValueProvider<O>(values);
    }

    private CollectionSequentialElementValueProvider(Collection<O> values) {
        this.values = Collections.synchronizedList(new ArrayList<O>(values));
        this.currentCount = new AtomicInteger();
    }

    @Override
    public String get() {
        O value = this.values.get(this.currentCount.getAndIncrement() % this.values.size());
        return Objects.toString(value);
    }
}

