/*
 * Decompiled with CFR 0.152.
 */
package be.davidopdebeeck.document.randomizer;

import be.davidopdebeeck.document.randomizer.Randomizer;
import be.davidopdebeeck.document.randomizer.SimpleRandomizer;
import be.davidopdebeeck.document.randomizer.document.Document;
import be.davidopdebeeck.document.randomizer.document.DocumentProcessingService;
import be.davidopdebeeck.document.randomizer.document.DocumentProcessorFactory;
import be.davidopdebeeck.document.randomizer.element.mapping.ElementValueMapping;
import be.davidopdebeeck.document.randomizer.json.JsonDocument;
import be.davidopdebeeck.document.randomizer.json.JsonDocumentFactory;
import be.davidopdebeeck.document.randomizer.xml.XmlDocument;
import be.davidopdebeeck.document.randomizer.xml.XmlDocumentFactory;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Randomizers {
    public static Randomizer xmlRandomizer(List<ElementValueMapping> elementValueMappings) {
        Objects.requireNonNull(elementValueMappings);
        return new SimpleRandomizer<XmlDocument>(new XmlDocumentFactory(), Randomizers.createDocumentProcessingService(elementValueMappings));
    }

    public static Randomizer jsonRandomizer(List<ElementValueMapping> elementValueMappings) {
        Objects.requireNonNull(elementValueMappings);
        return new SimpleRandomizer<JsonDocument>(new JsonDocumentFactory(), Randomizers.createDocumentProcessingService(elementValueMappings));
    }

    private static <D extends Document> DocumentProcessingService<D> createDocumentProcessingService(List<ElementValueMapping> elementValueMappings) {
        DocumentProcessorFactory processorFactory = new DocumentProcessorFactory();
        return new DocumentProcessingService(elementValueMappings.stream().map(processorFactory::create).collect(Collectors.toList()));
    }
}

