/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mongomail.server;

import be.cylab.mongomail.bizz.Connection;
import be.cylab.mongomail.db.IMailDao;
import be.cylab.mongomail.server.Configuration;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;

public class Server {
    private static ServerSocket server;
    private static boolean running;

    private Server() {
    }

    public static void launchServer(String dotenv_path, String log4j_path) {
        System.setProperty("log4j.configurationFile", log4j_path + "log4j2.xml");
        Configuration config = new Configuration(dotenv_path);
        final int port = config.getInt("MONGOMAIL_SERVER_PORT");
        final String hostname = config.getString("MONGOMAIL_SERVER_HOSTNAME");
        int max_connections = config.getInt("MONGOMAIL_CONNECTION_MAX");
        int idle_timeout = config.getInt("MONGOMAIL_IDLE_TIMEOUT");
        final IMailDao db = (IMailDao)config.getImplementingInstance(IMailDao.class);
        final ThreadPoolExecutor thread_pool = new ThreadPoolExecutor(0, max_connections, idle_timeout, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        running = true;
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    server = new ServerSocket(port);
                    LogManager.getLogger(Server.class).info("Smtp Server " + hostname + " listening on port " + port);
                    while (running) {
                        Socket socket = server.accept();
                        Connection connection = new Connection(socket, db);
                        thread_pool.submit(connection);
                        LogManager.getLogger(Server.class).info("New connection from " + socket.getInetAddress().getHostAddress());
                    }
                }
                catch (IOException exc) {
                    if (exc.getClass().equals(SocketException.class)) {
                        LogManager.getLogger(Server.class).fatal("Server successfully closed");
                    }
                    LogManager.getLogger(Server.class).fatal("Unable to open serverSocket");
                }
            }
        };
        t.start();
    }

    public static void stopServer() {
        try {
            running = false;
            server.close();
        }
        catch (IOException ex) {
            LogManager.getLogger(Server.class).fatal("Unable to close serverSocket");
        }
    }
}

