/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mongomail.server;

import be.cylab.mongomail.server.IConfiguration;
import be.cylab.mongomail.server.Server;
import io.github.cdimascio.dotenv.Dotenv;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;

class Configuration
implements IConfiguration {
    private final Map<Class, Object> cache_singletons;
    private final Properties prop = new Properties();
    private final Dotenv dotenv;

    public Configuration(String dotenv_path) {
        try {
            InputStream input = this.getClass().getResourceAsStream("injection.properties");
            this.prop.load(input);
        }
        catch (IOException exc) {
            LogManager.getLogger(Configuration.class).fatal("injection.properties cannot be found !Verify that all files of MongoMail are present !");
        }
        this.cache_singletons = new HashMap<Class, Object>();
        this.cache_singletons.put(IConfiguration.class, this);
        this.dotenv = Dotenv.configure().directory(dotenv_path).load();
    }

    @Override
    public String getString(String key) {
        return this.dotenv.get(key);
    }

    @Override
    public int getInt(String key) {
        if (this.dotenv.get(key) == null) {
            return -1;
        }
        return Integer.parseInt(this.dotenv.get(key));
    }

    public Object getImplementingInstance(Class interface_of_the_instance) {
        if (this.cache_singletons.containsKey(interface_of_the_instance)) {
            return this.cache_singletons.get(interface_of_the_instance);
        }
        String impl_name = this.prop.getProperty(interface_of_the_instance.getSimpleName());
        try {
            Constructor<?> constructor = Class.forName(impl_name).getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            Class<?>[] parameter_list = constructor.getParameterTypes();
            ArrayList<Object> parameter_instanciated = new ArrayList<Object>();
            for (Class<?> current_class : parameter_list) {
                parameter_instanciated.add(this.getImplementingInstance(current_class));
            }
            Object instance = constructor.newInstance(parameter_instanciated.toArray());
            this.cache_singletons.put(interface_of_the_instance, instance);
            return instance;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exc) {
            LogManager.getLogger(Server.class).fatal("Want to instanciate inexisting command. Normally never happen !");
            return null;
        }
    }
}

