/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mongomail.db;

import be.cylab.mongomail.db.IDbService;
import be.cylab.mongomail.server.IConfiguration;
import com.mongodb.MongoClientSettings;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;

class DbService
implements IDbService {
    private final MongoClient mongo_client;
    private final MongoDatabase mongo_database;
    private final MongoCollection mongo_collection;
    private final GridFSBucket bucket;

    public DbService(IConfiguration config) {
        int db_port = config.getInt("MONGOMAIL_DB_PORT");
        String db_host = config.getString("MONGOMAIL_DB_HOST");
        String db_name = config.getString("MONGOMAIL_DB_NAME");
        String collection_name = config.getString("MONGOMAIL_COLLECTION_NAME");
        String bucket_name = config.getString("MONGOMAIL_BUCKET_NAME");
        this.mongo_client = MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyToClusterSettings(builder -> builder.hosts(Arrays.asList(new ServerAddress(db_host, db_port)))).build());
        this.bucket = GridFSBuckets.create((MongoDatabase)this.mongo_client.getDatabase(db_name), (String)bucket_name);
        this.mongo_database = this.mongo_client.getDatabase(db_name);
        this.mongo_collection = this.mongo_client.getDatabase(db_name).getCollection(collection_name);
        LogManager.getLogger(DbService.class).info("Successfully connected to dabatase !");
    }

    @Override
    public MongoCollection getCollection() {
        return this.mongo_collection;
    }

    @Override
    public GridFSBucket getGridFSBucket() {
        return this.bucket;
    }
}

