/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mongomail.bizz;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

enum ProtocolState {
    INIT("HELO", "QUIT", "NOOP"),
    HELO("MAIL", "QUIT", "NOOP"),
    MAIL("RCPT", "RSET", "QUIT", "NOOP"),
    RCPT("RCPT", "DATA", "RSET", "QUIT", "NOOP"),
    DATA("RSET", "QUIT", "NOOP"),
    QUIT(new String[0]);

    private final HashMap<ProtocolState, HashSet<String>> implemented_commands = new HashMap();

    private ProtocolState(String ... command_names) {
        HashSet<String> names_set = new HashSet<String>(Arrays.asList(command_names));
        this.implemented_commands.put(this, names_set);
    }

    public boolean canExecute(String command_name) {
        return this.implemented_commands.get((Object)this).contains(command_name);
    }

    public ProtocolState changeState(String command) {
        switch (command) {
            case "HELO": {
                return HELO;
            }
            case "MAIL": {
                return MAIL;
            }
            case "RCPT": {
                return RCPT;
            }
            case "DATA": {
                return DATA;
            }
            case "QUIT": {
                return QUIT;
            }
            case "NOOP": {
                return this;
            }
            case "RSET": {
                return HELO;
            }
        }
        throw new IllegalStateException();
    }
}

