/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mongomail.bizz;

import be.cylab.mongomail.bizz.Client;
import be.cylab.mongomail.bizz.Mail;
import be.cylab.mongomail.bizz.MailParsingException;
import be.cylab.mongomail.bizz.MimeParser;
import be.cylab.mongomail.bizz.ProtocolException;
import be.cylab.mongomail.bizz.SmtpProtocol;
import be.cylab.mongomail.db.IMailDao;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;

public class Connection
implements Runnable {
    private final Socket client_socket;
    private final IMailDao mail_dao;
    private final Client client;
    private final SmtpProtocol protocol;

    public Connection(Socket socket, IMailDao mail_dao) {
        this.client_socket = socket;
        this.mail_dao = mail_dao;
        this.client = new Client();
        this.client.setMail(new Mail());
        this.protocol = new SmtpProtocol(this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (PrintWriter out = new PrintWriter(this.client_socket.getOutputStream());
             BufferedReader in = new BufferedReader(new InputStreamReader(this.client_socket.getInputStream()));){
            out.flush();
            this.client.setIn(in);
            this.client.setOut(out);
            this.protocol.handleProtocol();
            LogManager.getLogger(Connection.class).info("client " + this.client_socket.getInetAddress().getHostAddress() + " - Mail correcty received by the protocol");
        }
        catch (IOException exc) {
            LogManager.getLogger(Connection.class).warn("client " + this.client_socket.getInetAddress().getHostAddress() + " - IOException with socket.");
        }
        catch (ProtocolException exc) {
            LogManager.getLogger(Connection.class).warn("client " + this.client_socket.getInetAddress().getHostAddress() + " - " + exc.getMessage());
        }
        finally {
            this.closeSocket();
        }
        if (this.client.getMail().validateMailAfterProtocol()) {
            this.parseAndRegisterMail();
        }
    }

    private void parseAndRegisterMail() {
        try {
            MimeParser mime_parser = new MimeParser(this.client.getMail());
            mime_parser.convertToDocument();
            this.mail_dao.insertMime(this.client.getMail());
            LogManager.getLogger(Connection.class).info("client " + this.client_socket.getInetAddress().getHostAddress() + " - Mail correctly parsed and stored.");
        }
        catch (MailParsingException exc) {
            LogManager.getLogger(Connection.class).warn("client " + this.client_socket.getInetAddress().getHostAddress() + " - " + exc.getMessage());
        }
    }

    private void closeSocket() {
        try {
            this.client_socket.close();
        }
        catch (IOException exc) {
            LogManager.getLogger(Connection.class).warn("client " + this.client_socket.getInetAddress().getHostAddress() + " - Error while closing socket.");
        }
    }
}

