/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mongomail.bizz;

import be.cylab.mongomail.bizz.Command;
import be.cylab.mongomail.bizz.IClient;
import be.cylab.mongomail.bizz.Reply;
import be.cylab.mongomail.bizz.ReplyCode;
import be.cylab.mongomail.bizz.Util;

class CommandRcpt
extends Command {
    private String recipient_mail;

    public CommandRcpt(IClient client) {
        super(client);
    }

    @Override
    public void execute(String client_line) {
        if (!this.retrieveAddress(client_line)) {
            super.getClient().sendReply(new Reply(ReplyCode.SYNTAX_ERROR, "Syntax: RCPT TO:<recipient@domain.com>"));
            return;
        }
        if (!this.verifyAddress()) {
            super.getClient().sendReply(new Reply(ReplyCode.INVALID_MAILBOX_SYNTAX, "Invalid email address: " + this.recipient_mail));
            return;
        }
        this.verifyAddressPresenceAndAdd();
        this.respond();
    }

    private boolean retrieveAddress(String client_line) {
        String[] args = client_line.split("\\s+");
        if (args.length < 2) {
            return false;
        }
        String mail_part = args[1].replace('<', ' ').replace('>', ' ');
        if ((args = mail_part.split("\\s+")).length < 2) {
            return false;
        }
        this.recipient_mail = args[1];
        return true;
    }

    private boolean verifyAddress() {
        return Util.checkEmail(this.recipient_mail);
    }

    private boolean verifyAddressPresenceAndAdd() {
        return super.getClient().getMail().addRecipient(this.recipient_mail);
    }

    private void respond() {
        super.getClient().sendReply(new Reply(ReplyCode.OK, "OK"));
    }
}

