package be.cylab.mongomail.db;

import be.cylab.mongomail.bizz.IMailDto;
import org.bson.Document;
import static be.cylab.mongomail.bizz.Util.*;
import com.mongodb.client.gridfs.GridFSUploadStream;
import java.util.ArrayList;
import org.bson.types.ObjectId;

/**
 * Dao means Data access object. MailDao provides all methods to interact with
 * the mail collection in database.
 *
 * @author Bunyamin Aslan
 */
class MailDao implements IMailDao {

    /**
     * "TEXT" string.
     */
    public static final String TEXT = "text";
    /**
     * "CONTENT-TYPE" string.
     */
    public static final String CONTENT_TYPE = "CONTENT-TYPE";
    /**
     * "BODY" string.
     */
    public static final String BODY = "BODY";
    /**
     * "FILENAME" string.
     */
    public static final String FILENAME = "FILENAME";
    /**
     * FILE-ID String.
     */
    private static final String FILE_ID = "FILE-ID";
    private final IDbService db_service;

    /**
     * Constructor of MailDao.
     *
     * @param db_service object
     */
    public MailDao(final IDbService db_service) {
        this.db_service = db_service;
    }

    @Override
    public void insertMime(final IMailDto mail) {
        Document document = mail.getDocument();
        ArrayList<Document> bodyparts
                = (ArrayList<Document>) document.get(BODY);
        for (int i = 0, j = 0; i < bodyparts.size(); i++) {
            String content_type = (String) bodyparts.get(i).get(CONTENT_TYPE);
            if (checkString(content_type) && !content_type.startsWith(TEXT)) {
                //If not text, it's attachment
                ObjectId file_id;
                try (GridFSUploadStream uploadStream = this.db_service.
                        getGridFSBucket().openUploadStream(bodyparts.get(i).
                                getString(FILENAME))) {
                    uploadStream.write(mail.getAttachments().get(j));
                    file_id = uploadStream.getObjectId();
                }
                j++;
                //Add file_id to document to easily retrieve file from document
                bodyparts.get(i).put(FILE_ID, file_id);
            }
        }
        this.db_service.getCollection().insertOne(document);
    }
}
