package be.cylab.mongomail.bizz;

/**
 * Contain util methods.
 *
 * @author Bunyamin Aslan
 */
public class Util {

    private Util() {

    }

    /**
     * Empty string regex.
     */
    public static final String EMPTY_STRING_REGEX = "^\\s+$";
    /**
     * Email regex.
     */
    public static final String EMAIL_REGEX = "^(\\w\\.?)+@\\w+(\\.\\w+)+$";
    /**
     * Space regex.
     */
    public static final String SPACE_REGEX = "\\s+";

    /**
     * Check if the object isnt null.
     *
     * @param obj to check
     * @return true if the object is not null, false otherwise
     */
    public static boolean checkObject(final Object obj) {
        return obj != null;
    }

    /**
     * Check if the String isnt null or empty.
     *
     * @param str to check
     * @return true if it's a valid string, false otherwise
     */
    public static boolean checkString(final String str) {
        return checkObject(str) && !str.matches(EMPTY_STRING_REGEX);
    }

    /**
     * Check if the email string has an email regex.
     *
     * @param email to check
     * @return true if email has a valid syntax, false otherwise
     */
    public static boolean checkEmail(final String email) {
        return checkString(email) && email.matches(EMAIL_REGEX);
    }

}
