package be.cylab.mongomail.bizz;

import java.io.BufferedReader;
import java.io.PrintWriter;

/**
 * Interface for Client.
 *
 * @author Bunyamin Aslan
 */
interface IClient {

    /**
     * Send to the client via the ouput the reply.
     *
     * @param reply to send
     */
    void sendReply(Reply reply);

    /**
     * Read the client command via in.
     *
     * @return red command
     */
    String read();

    /* GETTERS AND SETTERS */
    /**
     * Getter mail.
     *
     * @return mail
     */
    Mail getMail();

    /**
     * Setter mail.
     *
     * @param mail.
     */
    void setMail(Mail mail);

    /**
     * Getter in.
     *
     * @return in.
     */
    BufferedReader getIn();

    /**
     * setter in.
     *
     * @param in
     */
    void setIn(BufferedReader in);

    /**
     * getter out.
     *
     * @return out.
     */
    PrintWriter getOut();

    /**
     * setter out.
     *
     * @param out.
     */
    void setOut(PrintWriter out);

    /**
     * getter domain.
     *
     * @return domain.
     */
    String getDomain();

    /**
     * setter domain.
     *
     * @param domain.
     */
    void setDomain(String domain);

}
