/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mongomail.bizz;

import be.cylab.mongomail.bizz.Client;
import be.cylab.mongomail.bizz.CommandFactory;
import be.cylab.mongomail.bizz.CommandName;
import be.cylab.mongomail.bizz.ProtocolState;
import be.cylab.mongomail.bizz.Reply;
import be.cylab.mongomail.bizz.ReplyCode;

class SmtpProtocol {
    private final Client client;
    private final CommandFactory command_factory;
    private ProtocolState state;

    public SmtpProtocol(Client client) {
        this.client = client;
        this.command_factory = new CommandFactory();
        this.state = ProtocolState.INIT;
    }

    public void handleProtocol() {
        String command_line;
        this.client.sendReply(new Reply(ReplyCode.SERVICE_READY, "ERM_SMTP_Server ready"));
        while ((command_line = this.client.read()) != null) {
            String command_name = this.parseCommand(command_line).toUpperCase();
            if (!CommandName.ALL_COMMANDS.contains(command_name)) {
                this.client.sendReply(new Reply(ReplyCode.UNKNOWN, "unrecognized command"));
                continue;
            }
            if (CommandName.NOT_IMPLEMENTED_COMMANDS.contains(command_name)) {
                this.client.sendReply(new Reply(ReplyCode.NOT_IMPLEMENTED, "not implemented"));
                continue;
            }
            if (!this.state.canExecute(command_name)) {
                this.client.sendReply(new Reply(ReplyCode.BAD_SEQUENCE, "bad command sequence"));
                continue;
            }
            this.command_factory.getCommand(command_name, this.client).execute(command_line);
            this.state = this.state.changeState(command_name);
            if (!this.state.equals((Object)ProtocolState.QUIT)) continue;
            break;
        }
    }

    private String parseCommand(String command) {
        return command.split(" ")[0];
    }
}

