/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mongomail.bizz;

import be.cylab.mongomail.bizz.Command;
import be.cylab.mongomail.bizz.IClient;
import be.cylab.mongomail.bizz.Reply;
import be.cylab.mongomail.bizz.ReplyCode;
import be.cylab.mongomail.bizz.Util;

class CommandMail
extends Command {
    private String sender_mail;

    public CommandMail(IClient client) {
        super(client);
    }

    @Override
    public void execute(String client_line) {
        if (!this.retrieveAddress(client_line)) {
            super.getClient().sendReply(new Reply(ReplyCode.SYNTAX_ERROR, "Syntax: MAIL FROM:<sendermail@domain.com>"));
            return;
        }
        if (!this.verifyAddressAndAdd()) {
            super.getClient().sendReply(new Reply(ReplyCode.INVALID_MAILBOX_SYNTAX, "Invalid email address: " + this.sender_mail));
            return;
        }
        this.respond();
    }

    private boolean retrieveAddress(String client_line) {
        String[] args = client_line.split("\\s+");
        if (args.length < 2) {
            return false;
        }
        String mail_part = args[1].replace('<', ' ').replace('>', ' ');
        if ((args = mail_part.split("\\s+")).length < 2) {
            return false;
        }
        this.sender_mail = args[1];
        return true;
    }

    private boolean verifyAddressAndAdd() {
        if (!Util.checkEmail(this.sender_mail)) {
            return false;
        }
        super.getClient().getMail().setSenderEmail(this.sender_mail);
        return true;
    }

    private void respond() {
        super.getClient().sendReply(new Reply(ReplyCode.OK, "OK"));
    }
}

