package be.cylab.mongomail.bizz;

/**
 * Handle all operation that belongs to smtpProtocol and client interaction. See
 * more in SMTP Protocol document.
 *
 * @author Bunyamin Aslan
 */
class SmtpProtocol {

    private final Client client;
    private final CommandFactory command_factory;
    private ProtocolState state;

    /**
     * Constructor of Smtp Protocol.
     *
     * @param client with who we communicate
     * @param factory to instantiate objects
     */
    public SmtpProtocol(final Client client) {
        this.client = client;
        this.command_factory = new CommandFactory();
        this.state = ProtocolState.INIT;
    }

    public void handleProtocol() {
        String command_line;
        client.sendReply(new Reply(
                ReplyCode.SERVICE_READY, "ERM_SMTP_Server ready"));
        while ((command_line = client.read()) != null) {
            String command_name = parseCommand(command_line).toUpperCase();
            //If unknown
            if (!CommandName.ALL_COMMANDS.contains(command_name)) {
                client.sendReply(
                        new Reply(ReplyCode.UNKNOWN,
                                "unrecognized command"));
                continue;
            }
            //If not implemented
            if (CommandName.NOT_IMPLEMENTED_COMMANDS.contains(command_name)) {
                client.sendReply(new Reply(
                        ReplyCode.NOT_IMPLEMENTED, "not implemented"));
                continue;
            }
            //If we cant execute this command in this state
            if (!this.state.canExecute(command_name)) {
                client.sendReply(new Reply(
                        ReplyCode.BAD_SEQUENCE, "bad command sequence"));
                continue;
            }
            //If we can execute the command
            this.command_factory.getCommand(command_name, client).
                    execute(command_line);
            this.state = this.state.changeState(command_name);
            //If the protocol has reached QUIT state, we can close connection
            if (this.state.equals(ProtocolState.QUIT)) {
                break;
            }

        }
    }

    /**
     * Parse the command to get the command name.
     *
     * @param command read from client
     * @return command name
     */
    private String parseCommand(final String command) {
        return command.split(" ")[0];
    }

}
