package be.cylab.mongomail.bizz;

import java.util.ArrayList;
import java.util.HashSet;
import org.bson.Document;
import static be.cylab.mongomail.bizz.Util.*;

/**
 * Mail Object. Contains all information about the received mail.
 *
 * @author Bunyamin Aslan
 */
class Mail implements IMailDto {

    private String sender_email;
    private HashSet<String> recipients_emails;
    private String content;
    private final ArrayList<byte[]> attachments;
    private Document document;

    /**
     * Constructor of mail.
     */
    public Mail() {
        this.recipients_emails = new HashSet<>();
        this.attachments = new ArrayList<>();
    }

    public boolean validateMailAfterProtocol() {
        return checkEmail(sender_email) && checkString(content)
                && !recipients_emails.isEmpty();
    }

    @Override
    public String getSenderEmail() {
        return this.sender_email;
    }

    @Override
    public void setSenderEmail(final String sender_email) {
        this.sender_email = sender_email;
    }

    @Override
    public HashSet<String> getRecipientsEmail() {
        return this.recipients_emails;
    }

    @Override
    public boolean addRecipient(final String recipient_email) {
        return this.recipients_emails.add(recipient_email);
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(final String content) {
        this.content = content;
    }

    public void resetMail() {
        this.content = null;
        this.sender_email = null;
        this.recipients_emails = new HashSet<>();
    }

    @Override
    public void addAttachment(final byte[] attachment) {
        this.attachments.add(attachment);
    }

    @Override
    public ArrayList<byte[]> getAttachments() {
        return this.attachments;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(final Document document) {
        this.document = document;
    }
}
