package be.cylab.mongomail.bizz;

import java.util.ArrayList;
import java.util.HashSet;
import org.bson.Document;

/**
 * Interface for Mail. Dto means that this interface contains only basic methods
 * (getters and setters).
 *
 *
 * @author Bunyamin Aslan
 */
public interface IMailDto {

    /* GETTERS AND SETTERS */
    /**
     * Getter document.
     *
     * @return document
     */
    Document getDocument();

    /**
     * Setter document.
     *
     * @param document.
     */
    void setDocument(Document document);

    /**
     * getter attachments.
     *
     * @return attachments.
     */
    ArrayList<byte[]> getAttachments();

    /**
     * adder attachment.
     *
     * @param attachment a byte array representing an attached file
     */
    void addAttachment(byte[] attachment);

    /**
     * getter sender_email.
     *
     * @return sender_email.
     */
    String getSenderEmail();

    /**
     * setter sender_email.
     *
     * @param sender_email email address of sender
     */
    void setSenderEmail(String sender_email);

    /**
     * getter recipients_email.
     *
     * @return recipients_email
     */
    HashSet<String> getRecipientsEmail();

    /**
     * adder recipient_email to recipients_email.
     *
     * @param recipient_email email address of recipient
     * @return true if the recipient is added, false otherwise
     */
    boolean addRecipient(String recipient_email);

    /**
     * getter content.
     *
     * @return content
     */
    String getContent();

    /**
     * setter content.
     *
     * @param content body of  email
     */
    void setContent(String content);
}
