package be.cylab.mongomail.bizz;

/**
 * QUIT Command. See more on SMTP Protocol document.
 *
 * @author Bunyamin Aslan
 */
class CommandQuit extends Command {

    /**
     * Constructor of QuitCommand.
     *
     * @param client
     */
    public CommandQuit(final IClient client) {
        super(client);
    }

    /**
     * Step 1 : Respond "221 Closing Connection".
     *
     * @param client_line from client
     */
    @Override
    public void execute(final String client_line) {
        respond();
    }

    /**
     * Respond "221 Closing Connection".
     */
    private void respond() {
        super.getClient().sendReply(new Reply(
                ReplyCode.SERVICE_CLOSING, "Closing Connection"));
    }

}
