package be.cylab.mongomail.bizz;

/**
 * NOOP Command. See more on SMTP Protocol document.
 *
 * @author Bunyamin Aslan
 */
class CommandNoop extends Command {

    /**
     * Constructor of NoopCommand.
     *
     * @param client
     */
    public CommandNoop(final IClient client) {
        super(client);
    }

    /**
     * Step 1 : Respond "250 OK".
     *
     * @param client_line from client
     */
    @Override
    public void execute(final String client_line) {
        respond();
    }

    /**
     * Respond "250 OK".
     */
    private void respond() {
        super.getClient().sendReply(new Reply(ReplyCode.OK, "OK"));
    }

}
