package be.cylab.mongomail.bizz;

import static be.cylab.mongomail.bizz.Util.*;

/**
 * HELO command. See more on SMTP Protocol document.
 *
 * @author Bunyamin Aslan
 */
class CommandHelo extends Command {

    private String client_domain;

    /**
     * Constructor of HeloCommand.
     *
     * @param client
     */
    public CommandHelo(final IClient client) {
        super(client);
    }

    /**
     * Step 1 : Retrieve client domain. Step 2 : Respond "250 Hello
     * ClientDomain.com".
     *
     * @param client_line
     */
    @Override
    public void execute(final String client_line) {
        if (!retrieveDomain(client_line)) {
            super.getClient().sendReply(new Reply(
                    ReplyCode.SYNTAX_ERROR, "Syntax: HELO clientdomain"));
            return;
        }
        respond();
    }

    /**
     * Retrieve client domain.
     *
     * @param client_line from client.
     * @return true if domain is retrieved, false otherwise
     */
    private boolean retrieveDomain(final String client_line) {
        String[] args = client_line.split(SPACE_REGEX);
        if (args.length < 2) {
            return false;
        }
        this.client_domain = args[1];
        super.getClient().setDomain(this.client_domain);
        return true;
    }

    /**
     * Respond "250 Hello ClientDomain.com".
     */
    private void respond() {
        super.getClient().sendReply(new Reply(
                ReplyCode.OK, "Hello " + client_domain));
    }

}
