package be.cylab.mongomail.bizz;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import be.cylab.mongomail.server.Server;

/**
 * A factory is used to instanciate implementation of interfaces. That avoid
 * direct dependencies between classes.
 *
 * @author Bunyamin Aslan
 */
class CommandFactory {

    private final HashMap<String, Class> commands;

    /**
     * Constructor of Factory.
     *
     * Initializing the commands HashMap and adding commands.
     *
     */
    public CommandFactory() {
        this.commands = new HashMap<>();
        this.commands.put(CommandName.HELO, CommandHelo.class);
        this.commands.put(CommandName.MAIL, CommandMail.class);
        this.commands.put(CommandName.NOOP, CommandNoop.class);
        this.commands.put(CommandName.QUIT, CommandQuit.class);
        this.commands.put(CommandName.RCPT, CommandRcpt.class);
        this.commands.put(CommandName.RSET, CommandRset.class);
        this.commands.put(CommandName.DATA, CommandData.class);
    }

    /**
     * Return an instance of the wanted command.
     *
     * @param command_name
     * @param client
     * @return instance of command
     */
    public Command getCommand(
            final String command_name, final Client client) {
        try {
            return (Command) this.commands.get(command_name)
                    .getConstructors()[0].newInstance(client);
        } catch (InstantiationException
                | IllegalAccessException
                | InvocationTargetException exc) {
            LogManager.getLogger(Server.class).warn(
                    "Want to instanciate inexisting command. "
                    + "Normally never happen !");
            return null;
        }
    }
}
