package be.cylab.mongomail.bizz;

/**
 * DATA Command. See more on SMTP Protocole document.
 *
 * @author Bunyamin Aslan
 */
class CommandData extends Command {

    /**
     * Constructor of DataCommand.
     *
     * @param client
     */
    public CommandData(final IClient client) {
        super(client);
    }

    /**
     * Step 1 : Respond "354 Send message content; end with <CRLF>.<CRLF>". Step
     * 2 : Receive and read the mail. Step 3 : Respond "250 OK".
     *
     * @param client_line from the client
     */
    @Override
    public void execute(final String client_line) {
        respond354();
        receiveAndReadMail();
        respond250();
    }

    /**
     * Respond "354 Send message content; end with <CRLF>.<CRLF>".
     */
    private void respond354() {
        super.getClient().sendReply(
                new Reply(ReplyCode.DATA_START,
                        "Send message content; end with <CRLF>.<CRLF>"));
    }

    /**
     * Receive and read the mail.
     */
    private void receiveAndReadMail() {
        StringBuilder mail_content = new StringBuilder();
        String line;
        while ((line = super.getClient().read()) != null) {
            //If we have reached the end of the mail
            if (line.equals(".")) {
                mail_content.deleteCharAt(mail_content.length() - 1);
                break;
            }
            mail_content.append(line).append("\n");
        }
        super.getClient().getMail().setContent(mail_content.toString());
    }

    /**
     * Respond "250 OK".
     */
    private void respond250() {
        super.getClient().sendReply(new Reply(ReplyCode.OK, "OK"));
    }

}
