package be.cylab.mongomail.bizz;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Representation of the client who's listening on the other side of the socket.
 *
 * @author Bunyamin Aslan
 */
class Client implements IClient {

    private Mail mail;
    private String domain;
    private PrintWriter out;
    private BufferedReader in;

    @Override
    public void sendReply(final Reply reply) {
        out.print(reply.render());
        out.flush();
    }

    @Override
    public String read() {
        try {
            String line = in.readLine();
            return line;
        } catch (IOException ex) {
            throw new ProtocolException("can't read socket.", ex);
        }
    }

    @Override
    public Mail getMail() {
        return mail;
    }

    @Override
    public void setMail(final Mail mail) {
        this.mail = mail;
    }

    @Override
    public BufferedReader getIn() {
        return this.in;
    }

    @Override
    public void setIn(final BufferedReader in) {
        this.in = in;
    }

    @Override
    public PrintWriter getOut() {
        return this.out;
    }

    @Override
    public void setOut(final PrintWriter out) {
        this.out = out;
    }

    @Override
    public void setDomain(final String domain) {
        this.domain = domain;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

}
