package be.cylab.mongomail.db;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.gridfs.GridFSBucket;

/**
 * Interface for DbService.
 *
 * @author Bunyamin Aslan
 */
public interface IDbService {

    /**
     * Get and return the database named db_name.
     *
     * @return a MongoDatabase.
     */
    MongoCollection getCollection();

    /**
     * Get and return the GridFSBucket named bucket_name.
     *
     * @return a GridFSBucket
     */
    GridFSBucket getGridFSBucket();

}
