package be.cylab.mongomail.bizz;

/**
 * Reply to send to the client.
 *
 * @author Bunyamin Aslan
 */
class Reply {

    private final ReplyCode code;
    private final String message;

    /**
     * Constructor of Reply.
     *
     * @param code ReplyCode
     * @param message personnalized message
     */
    public Reply(final ReplyCode code, final String message) {
        this.code = code;
        this.message = message;
    }

    public String render() {
        return code.getValue() + " " + message + "\r\n";
    }

}
