package be.cylab.mongomail.bizz;

/**
 * RSET Command. See more on SMTP Protocol document.
 *
 * @author Bunyamin Aslan
 */
class CommandRset extends Command {

    /**
     * Constructor of RsetCommand.
     *
     * @param client
     */
    public CommandRset(final IClient client) {
        super(client);
    }

    /**
     *
     * step 1 : reset information about the mail. step 2 : respond "250 OK".
     *
     * @param client_line from client
     */
    @Override
    public void execute(final String client_line) {
        resetMail();
        respond();
    }

    /**
     * Reset the mail of the client.
     */
    private void resetMail() {
        super.getClient().getMail().resetMail();
    }

    /**
     * Respond 250 "OK".
     */
    private void respond() {
        super.getClient().sendReply(new Reply(ReplyCode.OK, "OK"));
    }

}
