package be.cylab.mongomail.bizz;

import java.util.Arrays;
import java.util.HashSet;

/**
 * Interface to store constants about commands.
 *
 * @author Bunyamin Aslan
 */
interface CommandName {

    /**
     * "HELO" string.
     */
    String HELO = "HELO";
    /**
     * "EHLO" string.
     */
    String EHLO = "EHLO";
    /**
     * "MAIL" string.
     */
    String MAIL = "MAIL";
    /**
     * "RCPT" string.
     */
    String RCPT = "RCPT";
    /**
     * "QUIT" string.
     */
    String QUIT = "QUIT";
    /**
     * "RSET" string.
     */
    String RSET = "RSET";
    /**
     * "NOOP" string.
     */
    String NOOP = "NOOP";
    /**
     * "DATA" string.
     */
    String DATA = "DATA";
    /**
     * "VRFY" string.
     */
    String VRFY = "VRFY";
    /**
     * HashSet containing not implemented smtp commands.
     */
    HashSet<String> NOT_IMPLEMENTED_COMMANDS
            = new HashSet<>(Arrays.asList(VRFY, EHLO));
    /**
     * HashSet containing not implemented smtp commands.
     */
    HashSet<String> ALL_COMMANDS
            = new HashSet<>(Arrays.asList(
                    HELO, MAIL, RCPT, QUIT, RSET, NOOP, DATA, VRFY, EHLO));

}
