package be.cylab.mongomail.bizz;

import static be.cylab.mongomail.bizz.Util.*;

/**
 * Mail Command. See more on SMTP Protocol document.
 *
 * @author Bunyamin Aslan
 */
class CommandMail extends Command {

    private String sender_mail;

    /**
     * Constructor of MailCommand.
     *
     * @param client
     */
    public CommandMail(final IClient client) {
        super(client);
    }

    /**
     * Step 1 : Retrieve the address. Step 2 : Verify if the address is valid
     * and add it if valid. Step 3 : Respond "250 OK".
     *
     * @param client_line
     */
    @Override
    public void execute(final String client_line) {
        if (!retrieveAddress(client_line)) {
            super.getClient().sendReply(new Reply(
                    ReplyCode.SYNTAX_ERROR,
                    "Syntax: MAIL FROM:<sendermail@domain.com>"));
            return;
        }
        if (!verifyAddressAndAdd()) {
            super.getClient().sendReply(new Reply(
                    ReplyCode.INVALID_MAILBOX_SYNTAX,
                    "Invalid email address: " + this.sender_mail));
            return;
        }
        respond();
    }

    /**
     * Retrieve the address.
     *
     * @param client_line from client
     * @return true if the address is retrieved, false otherwise
     */
    private boolean retrieveAddress(final String client_line) {
        String[] args = client_line.split(SPACE_REGEX);
        if (args.length < 2) {
            return false;
        }
        String mail_part = args[1].replace('<', ' ').replace('>', ' ');
        args = mail_part.split(SPACE_REGEX);
        if (args.length < 2) {
            return false;
        }
        this.sender_mail = args[1];
        return true;
    }

    /**
     * Verify if the address is valid and add it if valid.
     *
     * @return true if address is verified and added, false otherwise
     */
    private boolean verifyAddressAndAdd() {
        if (!checkEmail(this.sender_mail)) {
            return false;
        }
        super.getClient().getMail().setSenderEmail(sender_mail);
        return true;
    }

    /**
     * Respond "250 OK".
     */
    private void respond() {
        super.getClient().sendReply(new Reply(ReplyCode.OK, "OK"));
    }

}
