/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mongomail.db;

import be.cylab.mongomail.bizz.IMailDto;
import be.cylab.mongomail.bizz.Util;
import be.cylab.mongomail.db.IDbService;
import be.cylab.mongomail.db.IMailDao;
import com.mongodb.client.gridfs.GridFSUploadStream;
import java.util.ArrayList;
import org.bson.Document;
import org.bson.types.ObjectId;

class MailDao
implements IMailDao {
    public static final String TEXT = "text";
    public static final String CONTENT_TYPE = "CONTENT-TYPE";
    public static final String BODY = "BODY";
    public static final String FILENAME = "FILENAME";
    private static final String FILE_ID = "FILE-ID";
    private final IDbService db_service;

    public MailDao(IDbService db_service) {
        this.db_service = db_service;
    }

    @Override
    public void insertMime(IMailDto mail) {
        Document document = mail.getDocument();
        ArrayList bodyparts = (ArrayList)document.get((Object)BODY);
        int j = 0;
        for (int i = 0; i < bodyparts.size(); ++i) {
            ObjectId file_id;
            String content_type = (String)((Document)bodyparts.get(i)).get((Object)CONTENT_TYPE);
            if (!Util.checkString(content_type) || content_type.startsWith(TEXT)) continue;
            try (GridFSUploadStream uploadStream = this.db_service.getGridFSBucket().openUploadStream(((Document)bodyparts.get(i)).getString((Object)FILENAME));){
                uploadStream.write(mail.getAttachments().get(j));
                file_id = uploadStream.getObjectId();
            }
            ++j;
            ((Document)bodyparts.get(i)).put(FILE_ID, (Object)file_id);
        }
        this.db_service.getCollection().insertOne((Object)document);
    }
}

