/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mongomail.bizz;

import be.cylab.mongomail.bizz.IMailDto;
import be.cylab.mongomail.bizz.MailParsingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bson.Document;

class MimeParser {
    public static final String BODY = "BODY";
    public static final String FILENAME = "FILENAME";
    private static final String TO = "TO";
    private static final String CC = "CC";
    private static final String BCC = "BCC";
    private static final String CONTENT = "CONTENT";
    private static final String REPLY_TO = "REPLY-TO";
    private static final String RESENT_TO = "RESENT-TO";
    private static final String RESENT_CC = "RESENT-CC";
    private static final String RESENT_BCC = "RESENT-BCC";
    private MimeMessage mime;
    private Document mime_json = new Document();
    private IMailDto mail;

    public MimeParser(IMailDto mail) {
        this.mail = mail;
        try {
            this.mime = new MimeMessage(Session.getInstance((Properties)System.getProperties(), null), (InputStream)new ByteArrayInputStream(mail.getContent().getBytes()));
        }
        catch (MessagingException exc) {
            throw new MailParsingException("Mail data cannot be converted into mime. Bad mail content.", exc);
        }
    }

    public void convertToDocument() {
        try {
            this.parseHeaders(this.mime.getAllHeaders(), this.mime_json);
            this.parseBody();
        }
        catch (IOException | MessagingException exc) {
            throw new MailParsingException("Mail data cannot be parsed into document", exc);
        }
        this.mail.setDocument(this.mime_json);
    }

    private void parseBody() throws IOException, MessagingException {
        try {
            MimeMultipart multipart = (MimeMultipart)this.mime.getContent();
            this.handleMultipartMime(multipart);
        }
        catch (ClassCastException exc) {
            this.handleSimpleMime();
        }
    }

    private void handleMultipartMime(MimeMultipart multipart) throws MessagingException, IOException {
        ArrayList<Document> body = new ArrayList<Document>();
        int multipart_count = multipart.getCount();
        for (int i = 0; i < multipart_count; ++i) {
            BodyPart bodypart = multipart.getBodyPart(i);
            Document bodypart_document = new Document();
            this.parseHeaders(bodypart.getAllHeaders(), bodypart_document);
            if (bodypart.isMimeType("text/*")) {
                bodypart_document.put(CONTENT, (Object)((String)bodypart.getContent()));
            } else {
                int bytes_read;
                InputStream inputstream = bodypart.getInputStream();
                byte[] data = new byte[inputstream.available()];
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                while ((bytes_read = inputstream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, bytes_read);
                }
                this.mail.addAttachment(data);
                bodypart_document.put(FILENAME, (Object)this.parseFilename(bodypart.getFileName()));
            }
            body.add(bodypart_document);
        }
        this.mime_json.put(BODY, body);
    }

    private void handleSimpleMime() throws MessagingException, IOException {
        ArrayList<Document> body = new ArrayList<Document>();
        Document bodypart_document = new Document();
        bodypart_document.put(CONTENT, (Object)((String)this.mime.getContent()));
        body.add(bodypart_document);
        this.mime_json.put(BODY, body);
    }

    private void parseHeaders(Enumeration<Header> header_enum, Document document) throws MessagingException {
        block12: while (header_enum.hasMoreElements()) {
            Header h = header_enum.nextElement();
            switch (h.getName().toUpperCase()) {
                case "REPLY-TO": 
                case "RESENT-CC": 
                case "RESENT-TO": 
                case "RESENT-BCC": 
                case "CC": 
                case "BCC": 
                case "TO": {
                    this.parseComposedHeader(h.getName().toUpperCase(), h.getValue(), document);
                    continue block12;
                }
            }
            document.put(h.getName().toUpperCase(), (Object)h.getValue());
        }
    }

    private void parseComposedHeader(String header, String value, Document document) {
        ArrayList<String> composed_header = new ArrayList<String>();
        String[] values = value.split(", ");
        for (int i = 0; i < values.length; ++i) {
            composed_header.add(values[i]);
        }
        document.put(header, composed_header);
    }

    private String parseFilename(String filename) {
        String[] files = filename.split("/");
        return files[files.length - 1];
    }
}

