package be.cylab.mongomail.server;

import be.cylab.mongomail.bizz.Connection;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.apache.logging.log4j.LogManager;
import be.cylab.mongomail.db.IMailDao;

/**
 * Server. Configure the server and launch the socket listener.
 *
 * @author Bunyamin Aslan
 */
public class Server {

    /**
     * Create a server set by .env file settings and the server is listening
     * sockets.
     *
     * @param dotenv_path
     * @param log4j_path
     */
    public void launchServer(final String dotenv_path,
            final String log4j_path) {

        System.setProperty(
                "log4j.configurationFile", "./" + log4j_path + "log4j2.xml");

        Configuration config = new Configuration(dotenv_path);
        int port = config.getInt("SERVER_PORT");
        String hostname = config.getString("SERVER_HOSTNAME");
        //int core_connections = config.getInt("CONNECTION_CORE");
        int max_connections = config.getInt("CONNECTION_MAX");
        int idle_timeout = config.getInt("IDLE_TIMEOUT");

        ThreadPoolExecutor thread_pool = new ThreadPoolExecutor(
                /*core_connections*/0, max_connections, idle_timeout,
                TimeUnit.SECONDS, new SynchronousQueue<>());

        IMailDao db = (IMailDao) config.
                getImplementingInstance(IMailDao.class);

        LogManager.getLogger(Server.class).info(
                "Smtp Server " + hostname + " listening on port " + port);
        try {
            final ServerSocket server = new ServerSocket(port);
            while (true) {
                final Socket socket = server.accept();
                Connection connection = new Connection(socket, db);
                thread_pool.submit(connection);
                LogManager.getLogger(Server.class).info(
                        "New connection from "
                        + socket.getInetAddress().getHostAddress());
            }
        } catch (IOException exc) {
            LogManager.getLogger(Server.class).
                    fatal("Unable to open serverSocket");
        }

    }

}
