package be.cylab.mongomail.bizz;

/**
 * Contains ReplyCode values. See more on SMTP Protocol document.
 *
 * @author Bunyamin Aslan
 */
enum ReplyCode {

    /**
     * Service ready code 220.
     */
    SERVICE_READY(220),
    /**
     * Service closing code 221.
     */
    SERVICE_CLOSING(221),
    /**
     * Ok code 250.
     */
    OK(250),
    /**
     * Data Start code 354.
     */
    DATA_START(354),
    /**
     * Server not available code 421.
     */
    SERVER_NOT_AVAILABLE(421),
    /**
     * Max recipients reached code 452.
     */
    MAX_RECIPIENTS_REACHED(452),
    /**
     * Unknown code 500.
     */
    UNKNOWN(500),
    /**
     * Syntax error code 501.
     */
    SYNTAX_ERROR(501),
    /**
     * Not implemented code 502.
     */
    NOT_IMPLEMENTED(502),
    /**
     * Bad sequence code 503.
     */
    BAD_SEQUENCE(503),
    /**
     * Recipient Email Invalid code 550. invalid is not a syntactic meaning
     */
    RECIPIENT_EMAIL_INVALID(550),
    /**
     * Invalid Mailbox syntax code 554. Syntactic meaning.
     */
    INVALID_MAILBOX_SYNTAX(554);

    private final int value;

    /**
     * Constructor of ReplyCode.
     *
     * @param value is the code
     */
    private ReplyCode(final int value) {
        this.value = value;
    }

    /**
     * Return the code value.
     *
     * @return value.
     */
    public int getValue() {
        return value;
    }
}
