/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package be.cylab.mongomail.bizz;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

/**
 * Further information in diagram of protocol state in folder analysis
 * Ressources.
 *
 * @author Bunyamin Aslan
 */
public enum ProtocolState {

    /**
     * Before any contact with the client.
     */
    INIT(CommandName.HELO, CommandName.QUIT, CommandName.NOOP),
    /**
     * After receiving HELO.
     */
    HELO(CommandName.MAIL, CommandName.QUIT, CommandName.NOOP),
    /**
     * After receiving MAIL FROM.
     */
    MAIL(CommandName.RCPT,
            CommandName.RSET, CommandName.QUIT, CommandName.NOOP),
    /**
     * After receiving RCPT TO.
     */
    RCPT(CommandName.RCPT, CommandName.DATA,
            CommandName.RSET, CommandName.QUIT, CommandName.NOOP),
    /**
     * After receiving DATA.
     */
    DATA(CommandName.RSET, CommandName.QUIT, CommandName.NOOP),
    /**
     * After receiving QUIT.
     */
    QUIT;

    private final HashMap<ProtocolState, HashSet<String>> implemented_commands;

    /**
     * Constructor in private because enum.
     */
    private ProtocolState(final String... command_names) {
        this.implemented_commands = new HashMap<>();
        HashSet<String> names_set = new HashSet<>(Arrays.asList(command_names));
        this.implemented_commands.put(this, names_set);
    }

    /**
     * Check if it can execute this command given the state.
     *
     * @param command_name to execute
     * @return true if he can execute this command given the state, false
     * otherwise
     */
    public boolean canExecute(final String command_name) {
        return this.implemented_commands.get(this).contains(command_name);
    }

    /**
     * return the next state given the command.
     *
     * @param command which is executed
     * @return the next state given the command
     */
    public ProtocolState changeState(final String command) {
        switch (command) {
            case CommandName.HELO:
                return HELO;
            case CommandName.MAIL:
                return MAIL;
            case CommandName.RCPT:
                return RCPT;
            case CommandName.DATA:
                return DATA;
            case CommandName.QUIT:
                return QUIT;
            case CommandName.NOOP:
                return this;
            case CommandName.RSET:
                return HELO;
            default:
                throw new IllegalStateException(); //Normally never happen
        }
    }

}
