package be.cylab.mongomail.bizz;

/**
 * basic implementation of a command.
 *
 * @author Bunyamin Aslan
 */
abstract class Command {

    private final IClient client;

    /**
     * Common constructor for all comands.
     *
     * @param client with which we interact
     * @param factory to get a Reply
     */
    public Command(final IClient client) {
        this.client = client;
    }

    /**
     * Execute command.
     *
     * @param client_line from client.
     */
    public abstract void execute(final String client_line);

    /**
     * getter client.
     *
     * @return client.
     */
    public IClient getClient() {
        return this.client;
    }
}
