/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mark.core;

import be.cylab.mark.core.DetectionAgentInterface;
import be.cylab.mark.core.InvalidProfileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class DetectionAgentProfile {
    private String label = "";
    private String trigger_label = "";
    private String class_name = "";
    private HashMap<String, String> parameters = new HashMap();
    private static final Yaml PARSER = new Yaml((BaseConstructor)new Constructor(DetectionAgentProfile.class));

    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public final String getTriggerLabel() {
        return this.trigger_label;
    }

    public final void setTriggerLabel(String trigger_label) {
        this.trigger_label = trigger_label;
    }

    public final String getClassName() {
        return this.class_name;
    }

    public final void setClassName(String class_name) {
        this.class_name = class_name;
    }

    public final void setParameters(HashMap<String, String> parameters) {
        this.parameters = parameters;
    }

    public final HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public final String getParameter(String name) {
        return this.parameters.get(name);
    }

    public final String getParameterOrDefault(String name, String default_value) {
        return this.parameters.getOrDefault(name, default_value);
    }

    public static final DetectionAgentProfile fromFile(File file) throws FileNotFoundException {
        return DetectionAgentProfile.fromInputStream(new FileInputStream(file));
    }

    public static final DetectionAgentProfile fromInputStream(InputStream input) {
        return (DetectionAgentProfile)PARSER.loadAs(input, DetectionAgentProfile.class);
    }

    public final DetectionAgentInterface createInstance() throws InvalidProfileException {
        try {
            return (DetectionAgentInterface)Class.forName(this.class_name).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new InvalidProfileException("Cannot instantiate detection agent " + this.class_name + " : " + ex.getMessage(), ex);
        }
    }
}

