/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mark.core;

import be.cylab.mark.core.DataAgentInterface;
import be.cylab.mark.core.InvalidProfileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class DataAgentProfile {
    private String class_name;
    private String label;
    private Map<String, String> parameters;
    private File path;
    private static final Yaml PARSER = new Yaml((BaseConstructor)new Constructor(DataAgentProfile.class));

    public final String getClassName() {
        return this.class_name;
    }

    public final void setClassName(String class_name) {
        this.class_name = class_name;
    }

    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public final Map<String, String> getParameters() {
        return this.parameters;
    }

    public final File getPath() {
        return this.path;
    }

    public static final DataAgentProfile fromFile(File file) throws FileNotFoundException {
        DataAgentProfile profile = DataAgentProfile.fromInputStream(new FileInputStream(file));
        profile.path = file;
        return profile;
    }

    public static final DataAgentProfile fromInputStream(InputStream input) {
        return (DataAgentProfile)PARSER.loadAs(input, DataAgentProfile.class);
    }

    public final DataAgentInterface createInstance() throws InvalidProfileException {
        try {
            return (DataAgentInterface)Class.forName(this.class_name).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new InvalidProfileException("Cannot instantiate data agent " + this.class_name, ex);
        }
    }

    public final File getPath(String filename) throws FileNotFoundException {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            if (this.path == null) {
                throw new FileNotFoundException("provided modules directory is not valid (not a directory or no a valid path)");
            }
            file = new File(this.path.toURI().resolve(filename));
        }
        return file;
    }
}

