/*
 * Decompiled with CFR 0.152.
 */
package mark.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import mark.core.DetectionAgentInterface;
import mark.core.InvalidProfileException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class DetectionAgentProfile {
    public String label;
    public String trigger_label;
    public String class_name;
    public HashMap<String, String> parameters;
    private static final Yaml PARSER = new Yaml((BaseConstructor)new Constructor(DetectionAgentProfile.class));

    public static final DetectionAgentProfile fromFile(File file) throws FileNotFoundException {
        return DetectionAgentProfile.fromInputStream(new FileInputStream(file));
    }

    public static final DetectionAgentProfile fromInputStream(InputStream input) {
        return (DetectionAgentProfile)PARSER.loadAs(input, DetectionAgentProfile.class);
    }

    public final DetectionAgentInterface createInstance() throws InvalidProfileException {
        try {
            return (DetectionAgentInterface)Class.forName(this.class_name).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidProfileException("Cannot instantiate data agent " + this.class_name, ex);
        }
        catch (InstantiationException ex) {
            throw new InvalidProfileException("Cannot instantiate data agent " + this.class_name, ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidProfileException("Cannot instantiate data agent " + this.class_name, ex);
        }
    }

    public final boolean match(String label) {
        return label.startsWith(this.trigger_label);
    }
}

